#!C:/lua/Lua_for_AMB/lua.exe

--[[
function string.crc8bit(str): implemented in string library
function string.andbit(str): implemented in string library
function string.orbit(str): implemented in string library
function string.xorbit(str): implemented in string library

function amb.sendstring(slot,str)
function amb.crccheck(str)

function smb.sendbyte(msgbyte)
function smb.receivebyte(msgbyte)
function smb.checkack()
function smb.sendstart()
function smb.sendstop()

function convert.byte2hex(char)
function convert.string2hex(strout,strin)
function convert.hex2byte(str)
function convert.byte2binary(char)
function convert.string2binary(strout,strin)
function convert.binary2byte(str)
--]]



-- The following program is experimental.
-- It tests boolean functions implemented by G.Kluge.
-- It is not used for inequality computations.


function string.extract(str,lsbitpos,msbitpos)
	local i
	local strout = ""
	for i=1, string.len(str) do
		strout = convert.byte2binary(string.sub(str,i,i)) .. strout
	end
	return string.sub("00000000" .. strout,-msbitpos-1,-lsbitpos-1)
end

-- -- -- -- -- -- -- -- -- -- -- -- -- --
convert = {} -- conversion functions --

----------------------------------------------------------------------
function convert.byte2hex(char)
	return string.format("%02X",string.byte(char))
end

----------------------------------------------------------------------
function convert.string2hex(strout,strin)
-- convert a string into its hexadecimal representation
		local i, char
		local strout = strout
		local strin = strin
		if strin==nil then
			-- strin is optional
			strin = strout
			strout = ""
		end
		for i=1, string.len(strin), 1 do
			char = string.sub(strin,i,i)
			strout = strout .. convert.byte2hex(char) .. "."
		end
		return string.sub(strout,1,-2) -- don't display final dot
end

----------------------------------------------------------------------
function convert.hex2byte(str)
	return string.char(tonumber(str,16))
end

----------------------------------------------------------------------
function convert.byte2binary(str)
-- converts numeric integer to binary string
	local int = string.byte(str)
	local hash={
		["0"]="000",
		["1"]="001",
		["2"]="010",
		["3"]="011",
		["4"]="100",
		["5"]="101",
		["6"]="110",
		["7"]="111"}
		local octstr=string.format('%o',int)
	local binstr="00000"
	local i
	for i=1,string.len(octstr) do
		binstr=binstr..hash[string.sub(octstr,i,i)]
	end
	return string.sub(binstr,-8)
end

----------------------------------------------------------------------
function convert.string2binary(strout,strin)
-- convert a string into its binary representation
		local i, char
		local strout = strout
		local strin = strin
		if strin==nil then
			-- strin is optional
			strin = strout
			strout = ""
		end
		for i=1, string.len(strin), 1 do
			char = string.sub(strin,i,i)
			strout = strout .. convert.byte2binary(char) .. "."
		end
		return string.sub(strout,1,-2) -- don't display final dot
end

----------------------------------------------------------------------
function convert.binary2byte(str)
	return string.char(tonumber(str,2))
end


-- -- -- -- -- -- -- -- -- -- -- -- -- --
smb = {} -- SMBus functions --

----------------------------------------------------------------------
function smb.sendbyte(msgbyte)
-- ??
end

----------------------------------------------------------------------
function smb.receivebyte(msgbyte)
-- ??
end

----------------------------------------------------------------------
function smb.checkack()
	local ack=false
-- ??
	ack = true
	if monitoring then
		if not ack then print("error: didn\'t get expected acknowledge") end 
	end
	return ack
end

----------------------------------------------------------------------
function smb.sendstart()
-- ??
end

----------------------------------------------------------------------
function smb.sendstop()
-- ??
end

-- -- -- -- -- -- -- -- -- -- -- -- -- -- --
amb = {} -- AMB SMBus functions --

----------------------------------------------------------------------
function amb.sendstring(slot,str)
-- prepare message for AMB
	-- address AMB adds (x011xxxW), command (11011110), byte count, data --
	local adds = string.orbit(string.andbit(string.char(slot*2+1),"\15"),string.char(tonumber("30",16)))
	local msg = adds .. -- address x011xxxW
		convert.hex2byte("DE") .. -- command 11011110
		string.char(string.len(str)+1)  .. -- byte count
		 "\0" .. --reserved
		str -- devicefunction(1B), register(2B), data
	local crc = string.crc8bit(msg)
	msg = msg .. crc -- CRC8
-- send message
	-- send string --
	smb.sendstart()
	local i, msgbyte
	local monitor =  "to SMBus: "
	for i=1, string.len(msg), 1 do
		msgbyte = string.sub(msg,i,i)
		smb.sendbyte()
		smb.checkack()
		if monitoring then
			monitor = monitor .. convert.byte2hex(msgbyte) .. "."
		end
	end
	smb.sendstop()
	if monitoring then print(string.sub(monitor,1,-2)) end
	return msg
end

----------------------------------------------------------------------
function amb.crccheck(str)
-- check CRC of a received string
	local crccalc = string.crc8bit(string.sub(str,1,-2))
	local crcrcvd = string.sub(str,-1)
	local crcisequal = (crccalc == crcrcvd)
	if monitoring then
		print(convert.string2hex("from SMBus: ",str))
		local crcc = convert.byte2hex(crccalc)
		local crcr = convert.byte2hex(crcrcvd)
		if not crcisequal then
		--	print("CRC check ok: calc=" .. crcc .. ", rcvd=" .. crcr)
		--else
			print("error: CRC check error, calc=" .. crcc .. ", rcvd=" .. crcr)
		end
	end
	return crcisequal
end
	




--=======================================================================================
print("Content-Type: text/html \n\n")
print("\<HTML\>\<PRE\>")

monitoring = true

slot = 4
str = "frrdddd"
v=amb.sendstring(slot,str)

amb.crccheck(v)
print(convert.string2hex("test1: ",string.sub(v,8,-2)))

str=convert.hex2byte("34") ..
	convert.hex2byte("56") ..
	convert.hex2byte("9B") ..
	convert.hex2byte("0F") --should be F0
amb.crccheck(str)
print()

str=convert.hex2byte("55") ..
	convert.hex2byte("F0") ..
	convert.hex2byte("FF") ..
	convert.hex2byte("FF")
print(convert.string2binary(str))
print(string.extract(str,0,15))

print()

str=convert.string2binary("aaa: ","AB")
print(str)

print("\<\/PRE\>\<\/HTML\>")

