--Webbook 1 to Webbook 2 Format Converter
--Uses a WB1 Lua file as input
--Outputs a WB2 wb_usr.js
--
--Henrique Pinheiro (henrique@tecgraf.puc-rio.br)



--Writes a Tree Node (recursive), using indentation
function writenode(str, ind, tbl, lnk)
  local i, v
  if tbl.title then
    str = str .. ind .. "name: {"
    for i, v in tbl.title do
      if i == 1 then
        str = str .. "nl: \"" .. v .. "\", "
      else
        str = str .. i .. ": \"" .. v .. "\", "
      end
    end
    str = strsub(str, 1, strlen(str)-2) .. "},\n"
  end
  if tbl.link then
    str = str .. ind .. "link: \"" .. 
    tbl.link .. ".html\"\n"
  elseif tbl.bookmark then
    str = str .. ind .. "link: \"" ..
      lnk .. "#" .. tbl.bookmark .. "\"\n"
  else
    str = strsub(str, 1, strlen(str)-2) .. "\n"
  end
  tbl.link = tbl.link or strsub(lnk, 1, strlen(lnk)-5)
  if tbl.subitems then
    str = strsub(str, 1, strlen(str)-1) .. ",\n"
    str = str .. ind .. "folder:\n" .. ind .. "[\n"
    ind = ind .. "  "
    local last = getn(tbl.subitems)
    for i = 1, last do
      str = str .. ind .. "{\n"
      str = writenode(str, ind .. "  ", tbl.subitems[i], tbl.link .. ".html")
      li = strlen(str)
      str = str .. ind .. "},\n"
    end
    ind = strsub(ind, 1, strlen(ind)-2)
    str = strsub(str, 1, strlen(str)-2) .. "\n" .. ind .. "]\n"
  end
  str = strsub(str, 1, strlen(str)-1) .. "\n"
  return str
end

function writeoutput(fh)
  local last
--Starting wb_usr
  tmpstr = ""
  indent = "  "
  for i, v in wb_usr do
    if i ~= "langs" then
      tmpstr = tmpstr .. indent .. i .. " : \"" .. v .. "\",\n"
    else
      tmpstr = tmpstr .. "  langs : [\""
      last = getn(wb_usr.langs)
      for j = 1, last-1 do
        tmpstr = tmpstr .. wb_usr.langs[j] .. "\", \""
      end
      tmpstr = tmpstr .. wb_usr.langs[last] .. "\"],\n"
    end
  end
  tmpstr = tmpstr .. "  use_items : \"yes\",\n"
  tmpstr = tmpstr .. "  use_folders : \"no\",\n"
  tmpstr = tmpstr .. "  start_open : \"1\"\n"
  write(fh, "wb_usr = {\n" .. tmpstr .. "};\n")
  
--Starting wb_usr.messages
  tmpstr = ""
  indent = "  "
  for i, v in wb_messages do
    tmpstr = tmpstr .. indent .. i .. " : {\n"
    indent = indent .. "  "
    for j, w in v do
      tmpstr = tmpstr .. indent .. 
        j .. " : \"" .. w .. "\",\n"
    end
    tmpstr = strsub(tmpstr, 1, strlen(tmpstr)-2) .. "\n"
    indent = strsub(indent, 1, strlen(indent)-2)
    tmpstr = tmpstr .. indent .. "},\n"
  end
  tmpstr = strsub(tmpstr, 1, strlen(tmpstr)-2) .. "\n"
  write(fh, "\nwb_usr.messages = {\n" .. tmpstr .. "};\n")
  
--Starting wb_usr.tree
  indent = "  "
  tmpstr = ""
  lasttree = getn(wb_tree)
  write(fh, "\nwb_usr.tree = \n{\n")
  
  --writing main menu
  tmpstr = indent .. "name: {"
  for i, v in wb_messages do
    if i == 1 then
      tmpstr = tmpstr .. "nl: \"" .. v.title .. "\", "
    else
      tmpstr = tmpstr .. i .. ": \"" .. v.title .. "\", "
    end
  end
  tmpstr = strsub(tmpstr, 1, strlen(tmpstr)-2) .. "},\n"
  write(fh, tmpstr .. indent .. "folder:\n")
  write(fh, indent .. "[\n")
  write(fh, indent .. "  {\n")
  indent = indent .. "    "
  tmpstr = ""
  
  --continuing subnodes
  if lasttree <= 1 then
    tree = wb_tree
    write(fh, writenode(tmpstr, indent, tree, ""))
  else
    indent = strsub(indent, 1, strlen(indent)-2)
    for curtree = 1, lasttree do
      tree = wb_tree[curtree]
      if curtree > 1 then write(fh, indent .. "{\n") end
      write(fh, writenode(tmpstr, indent .. "  ", tree, ""))
      if curtree < lasttree then 
        write(fh, indent .. "},\n")
      else
        write(fh, indent .. "}\n")
      end
    end
    tmpstr = strsub(tmpstr, 1, strlen(tmpstr)-2) .. "\n"
  end
  --closing main menu
  write(fh, "  ]\n};\n")
end

local arg = arg or {}

if arg[1] and arg[2] then
  dofile(arg[1])
  outfile = openfile(arg[2], "w")
  write(outfile, "//Converted from WB1 Lua file\n")
  writeoutput(outfile)
else
  print("Usage:\nconvert [INPUT] [OUTPUT]")
  print("[INPUT] = The .lua Input File (WB 1)")
  print("[OUTPUT] = The .js Output File (WB 2)")  
end